#!/usr/bin/env python3
"""
Compiler ID  handling for dhfortran: tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 GNU Public License.

"""


import dhfortran.compilers as cp


def test_get_flavor():
    assert cp.get_fc_flavor("/usr/bin/gfortran") == "gfortran"
    assert cp.get_fc_flavor("/usr/bin/gfortran-14") == "gfortran14"
    assert cp.get_fc_flavor("/bin/aarch64-linux-gnu-gfortran-14") == "gfortran14"

    try:
        x = cp.get_fc_flavor("/bin/garbage")
    except Exception as ex:
        pass
    else:
        assert 1
        1, "get_fc_flavor('/bin/garbage') should fail"


def test_get_fort_root():
    assert cp.get_fort_root() == f"/usr/lib/{cp._multiarch}/fortran"


if __name__ == "__main__":
    import pytest

    pytest.main()
